﻿Imports System.Text
Imports WindowsApplication1.Module1
Imports System.Runtime.InteropServices



Public Class Form1
    Dim snr, tagtype As Long

    Dim data32(17) As Byte
    Dim databuff32(17) As Byte
    Dim databuff32_hex(33) As Byte
    Dim sector As Integer
    Dim block As Integer
    Dim cardtype As Integer 'card type 0:M1,1:S70
    Dim icdev As Integer
    Dim ihdevs(10) As Integer 'Store the handle list of readers

    Sub quit()
        If icdev > 0 Then
            Reader.fw_exit(icdev)
            icdev = -1
            ComboBox_DevList.Items.Clear()
        End If
    End Sub

    Sub UpdateCard()
        Dim i As Integer

        ComboBox_Sector.Items.Clear()
        ComboBox_Block.Items.Clear()

        If (0 = cardtype) Then
            'case of M1
            For i = 0 To 15
                ComboBox_Sector.Items.Add(i)
            Next i

            ComboBox_Sector.SelectedIndex = 0

            For i = 0 To 3
                ComboBox_Block.Items.Add(i)
            Next i

            ComboBox_Block.SelectedIndex = 1
        Else
            'case of S70
            For i = 0 To 39
                ComboBox_Sector.Items.Add(i)
            Next i

            ComboBox_Sector.SelectedIndex = 0

            For i = 0 To 3
                ComboBox_Block.Items.Add(i)
            Next i

            ComboBox_Block.SelectedIndex = 1
        End If

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        icdev = -1

        ComboBox_cardList.Items.Add("M1")
        ComboBox_cardList.Items.Add("S70")

        ComboBox_cardList.SelectedIndex = 0
        cardtype = 0

        UpdateCard()

    End Sub
    Private Sub btn_initial_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_link.Click
        Dim tmphdev As Integer
        Dim i As Integer
        Dim strdev As String
        Dim st As Integer
        Dim snbuf(100) As Byte
        Dim szSN(100) As Byte
        Dim strSN As String
        Dim lenbuf(2) As Integer



        ComboBox_DevList.Items.Clear()

        If Checkbox_portType.Checked = True Then

            'loop to get each handle of reader case of USB

            i = 0

            Do
                tmphdev = Reader.fw_init(100, 0)

                strdev = "Reader"

                If tmphdev <> -1 Then
                    ihdevs(i) = tmphdev
                    strdev = strdev + Str(i)

                    ComboBox_DevList.Items.Add(strdev)
                    ComboBox_DevList.Text = strdev

                    st = Reader.fw_GetDevSN(tmphdev, snbuf(0), lenbuf(0))
                    If st = 0 Then
                        Call Reader.hex_a(szSN(0), snbuf(0), 2 * lenbuf(0))
                        strSN = System.Text.Encoding.Default.GetString(szSN)
                        List1.Items.Add("DevSN:" + strSN)
                    End If

                End If

                i = i + 1

            Loop Until tmphdev < 0 And i < 100

            icdev = ihdevs(0)


        Else

            'case of serial port
            tmphdev = Reader.fw_init(0, 115200) 'COM1,baut rate 115200

            If tmphdev > 0 Then
                ComboBox_DevList.Items.Add("Reader 0")
                ComboBox_DevList.Text = "Reader 0"
                ihdevs(0) = tmphdev

            End If

        End If 'If Check1.value = 1 Then

        icdev = ihdevs(0)

        If icdev > 0 Then
            ComboBox_DevList.SelectedIndex = 0
        End If



        If icdev < 0 Then
            List1.Items.Add("Call fw_init() function error!")
        Else
            List1.Items.Add("Call fw_init() function success!")
        End If

    End Sub

    Private Sub ComboBox_DevList_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_DevList.SelectedIndexChanged
        Dim index As Integer

        'Chose special reader

        If icdev > 0 Then

            index = ComboBox_DevList.SelectedIndex
            icdev = ihdevs(index)

        End If
    End Sub

    Private Sub ComboBox_cardList_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_cardList.SelectedIndexChanged
        cardtype = ComboBox_cardList.SelectedIndex

        UpdateCard()

    End Sub

    Private Sub btn_unLink_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_unLink.Click
        quit()
        List1.Items.Add("Reader link disconnect")
    End Sub

    Private Sub ComboBox_Sector_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_Sector.SelectedIndexChanged
        Dim curSector As Integer
        Dim i As Integer

        ComboBox_Block.Items.Clear()

        curSector = ComboBox_Sector.SelectedIndex

        If (curSector < 32) Then

            For i = 0 To 3
                ComboBox_Block.Items.Add(4 * curSector + i)
            Next i

            ComboBox_Block.SelectedIndex = 1

        ElseIf curSector < 40 Then

            For i = 0 To 15
                ComboBox_Block.Items.Add(128 + 16 * (curSector - 32) + i)
            Next i

            ComboBox_Block.SelectedIndex = 0

        End If

    End Sub
    Private Sub btn_getCardUID_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_getCardUID.Click

        Dim st As Integer
        Dim cardbuf(100) As Byte
        Dim strCard As String
        Dim cardmode As Integer

        cardmode = 1

        st = Reader.fw_card_str(icdev, cardmode, cardbuf(0)) 'when cardmode=1,can repeat to find a card,otherwise must take away the card before redo when 0

        If st <> 0 Then
            Label_UID.Text = "NO Found"
            Exit Sub
        End If

        List1.Items.Add("Find card")


        strCard = System.Text.Encoding.Default.GetString(cardbuf) + " "
        strCard = "[Decimal]" + strCard

        Label_UID.Text = strCard

        Reader.fw_card_hex(icdev, cardmode, cardbuf(0))

        strCard = System.Text.Encoding.Default.GetString(cardbuf)
        strCard = "[HEX]" + strCard


        Label_UID.Text = Label_UID.Text + strCard


    End Sub

    Private Sub UpdateCardReadPara()
        sector = Integer.Parse(ComboBox_Sector.Text)
        block = Integer.Parse(ComboBox_Block.Text)
    End Sub

    Private Sub btn_read_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_read.Click
        Dim st As Integer
        Dim databuf(17) As Byte
        Dim strRead As String

        UpdateCardReadPara()

        st = Reader.fw_authentication(icdev, 0, sector)  'verify key
        If st <> 0 Then
            List1.Items.Add("Call fw_authentication() function error. Confirm that do find card before!")
            Exit Sub
        End If
        List1.Items.Add("Call fw_authentication() function success!")

        st = Reader.fw_read(icdev, block, databuf(0))   'read card
        If st <> 0 Then
            List1.Items.Add("Call fw_read function error")
            Exit Sub

        End If
        List1.Items.Add("Call fw_read function success")

        If (RadioBtn_Hex.Checked() = True) Then
            'read as hex string
            Call Reader.hex_a(databuff32_hex(0), databuf(0), 32)
            strRead = System.Text.Encoding.Default.GetString(databuff32_hex)
        Else
            'read as ASC string
            strRead = System.Text.Encoding.Default.GetString(databuf)
        End If

        Txt_data.Text = strRead

    End Sub

    Private Sub btn_write_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn_write.Click
        Dim st As Integer
        Dim strTxt As String
        Dim byt(100) As Byte

        UpdateCardReadPara()

        st = Reader.fw_authentication(icdev, 0, sector)  'verify key
        If st <> 0 Then
            List1.Items.Add("Call fw_authentication() function error. Confirm that do find card before!")
            Exit Sub
        End If
        List1.Items.Add("Call fw_authentication() function success!")

        strTxt = Txt_data.Text
        byt = System.Text.Encoding.Default.GetBytes(strTxt)

        If (RadioBtn_Hex.Checked() = True) Then
            'Write as hex mode
            If (byt.Length <> 32) Then
                List1.Items.Add("Data for writting length error, need 32 chars ")
                Exit Sub
            End If

            st = Reader.a_hex(data32(0), byt(0), 16)

            If st <> 0 Then
                List1.Items.Add("Data for writting format error")
                Exit Sub
            End If

            st = Reader.fw_write(icdev, block, data32(0)) 'Write data to card
            'NOTE: case of M1,the 4th block is the key block,
            'should not write the key block when testing

        Else
            'Write as ASC string mode
            st = Reader.fw_write(icdev, block, byt(0))
        End If

        If st <> 0 Then
            List1.Items.Add("Call fw_write() error!")
            Exit Sub
        End If

        List1.Items.Add("Call fw_write() function success!")
    End Sub

End Class
